/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.impl.LifecycleServiceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.NodeInvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.QueryCacheScheduler;
import com.hazelcast.map.impl.querycache.publisher.DefaultPublisherContext;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.subscriber.NodeQueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.subscriber.NodeQueryCacheEventService;
import com.hazelcast.map.impl.querycache.subscriber.NodeQueryCacheScheduler;
import com.hazelcast.map.impl.querycache.subscriber.NodeSubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;

public class NodeQueryCacheContext
implements QueryCacheContext {
    private final NodeEngine nodeEngine;
    private final InvokerWrapper invokerWrapper;
    private final MapServiceContext mapServiceContext;
    private final QueryCacheScheduler queryCacheScheduler;
    private final QueryCacheEventService queryCacheEventService;
    private final QueryCacheConfigurator queryCacheConfigurator;
    private final ContextMutexFactory lifecycleMutexFactory = new ContextMutexFactory();
    private PublisherContext publisherContext;
    private SubscriberContext subscriberContext;

    public NodeQueryCacheContext(MapServiceContext mapServiceContext) {
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.mapServiceContext = mapServiceContext;
        this.queryCacheScheduler = new NodeQueryCacheScheduler(mapServiceContext);
        this.queryCacheEventService = new NodeQueryCacheEventService(mapServiceContext, this.lifecycleMutexFactory);
        this.queryCacheConfigurator = new NodeQueryCacheConfigurator(this.nodeEngine, this.nodeEngine.getConfig(), this.queryCacheEventService);
        this.invokerWrapper = new NodeInvokerWrapper(this.nodeEngine.getOperationService());
        this.subscriberContext = new NodeSubscriberContext(this);
        this.publisherContext = new DefaultPublisherContext(this, this.nodeEngine, new RegisterMapListenerFunction());
        this.flushPublishersOnNodeShutdown();
    }

    private void flushPublishersOnNodeShutdown() {
        Node node = this.nodeEngine.getNode();
        LifecycleServiceImpl lifecycleService = node.hazelcastInstance.getLifecycleService();
        lifecycleService.addLifecycleListener(event -> {
            if (LifecycleEvent.LifecycleState.SHUTTING_DOWN == event.getState()) {
                this.publisherContext.flush();
            }
        });
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublisherContext getPublisherContext() {
        return this.publisherContext;
    }

    @Override
    public SubscriberContext getSubscriberContext() {
        return this.subscriberContext;
    }

    @Override
    public void setSubscriberContext(SubscriberContext subscriberContext) {
        this.subscriberContext = subscriberContext;
    }

    @Override
    public QueryCacheEventService getQueryCacheEventService() {
        return this.queryCacheEventService;
    }

    @Override
    public QueryCacheConfigurator getQueryCacheConfigurator() {
        return this.queryCacheConfigurator;
    }

    @Override
    public QueryCacheScheduler getQueryCacheScheduler() {
        return this.queryCacheScheduler;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return (InternalSerializationService)this.nodeEngine.getSerializationService();
    }

    @Override
    public Address getThisNodesAddress() {
        return this.nodeEngine.getThisAddress();
    }

    @Override
    public Collection<Member> getMemberList() {
        Collection<MemberImpl> memberList = this.nodeEngine.getClusterService().getMemberImpls();
        ArrayList<Member> members = new ArrayList<Member>(memberList.size());
        members.addAll(memberList);
        return members;
    }

    @Override
    public int getPartitionId(Object object) {
        assert (object != null);
        if (object instanceof Data) {
            Data data = (Data)object;
            this.nodeEngine.getPartitionService().getPartitionId(data);
        }
        return this.nodeEngine.getPartitionService().getPartitionId(object);
    }

    @Override
    public int getPartitionCount() {
        return this.nodeEngine.getPartitionService().getPartitionCount();
    }

    @Override
    public InvokerWrapper getInvokerWrapper() {
        return this.invokerWrapper;
    }

    @Override
    public Object toObject(Object obj) {
        return this.mapServiceContext.toObject(obj);
    }

    @Override
    public ContextMutexFactory getLifecycleMutexFactory() {
        return this.lifecycleMutexFactory;
    }

    private UUID registerLocalIMapListener(final String name) {
        return this.mapServiceContext.addLocalListenerAdapter(new ListenerAdapter<IMapEvent>(){

            @Override
            public void onEvent(IMapEvent event) {
            }

            public String toString() {
                return "Local IMap listener for the map '" + name + "'";
            }
        }, name);
    }

    private class RegisterMapListenerFunction
    implements Function<String, UUID> {
        private RegisterMapListenerFunction() {
        }

        @Override
        public UUID apply(String name) {
            return NodeQueryCacheContext.this.registerLocalIMapListener(name);
        }
    }
}

