/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ItemsByTag {
    private static final Object NONE = new Object();
    private final Map<Tag<?>, Object> map = new HashMap();

    @Nonnull
    public static ItemsByTag itemsByTag(Object ... tagsAndVals) {
        ItemsByTag ibt = new ItemsByTag();
        int i2 = 0;
        while (i2 < tagsAndVals.length) {
            ibt.put((Tag)tagsAndVals[i2++], tagsAndVals[i2++]);
        }
        return ibt;
    }

    @Nullable
    public <E> E get(@Nonnull Tag<E> tag) {
        Object got = this.map.getOrDefault(tag, NONE);
        if (got == NONE) {
            throw new IllegalArgumentException("No value associated with " + tag);
        }
        return (E)got;
    }

    public <E> void put(@Nonnull Tag<E> tag, @Nullable E value) {
        this.map.put(tag, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ItemsByTag)) return false;
        ItemsByTag tag = (ItemsByTag)o;
        if (!Objects.equals(this.map, tag.map)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public String toString() {
        return "ItemsByTag" + this.map;
    }

    @Nonnull
    Set<Map.Entry<Tag<?>, Object>> entrySet() {
        return this.map.entrySet();
    }
}

