/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import jakarta.mail.Flags;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.eclipse.angus.mail.imap.protocol.BASE64MailboxDecoder;

public class CommandParser {
    static final char CHR_SPACE = ' ';
    static final char CHR_CR = '\r';

    public String atom(ImapRequestLineReader request) throws ProtocolException {
        return this.consumeWord(request, new AtomCharValidator());
    }

    public String atomOnly(ImapRequestLineReader request) throws ProtocolException {
        return this.consumeWordOnly(request, new AtomCharValidator());
    }

    public String tag(ImapRequestLineReader request) throws ProtocolException {
        TagCharValidator validator = new TagCharValidator();
        return this.consumeWord(request, validator);
    }

    public String astring(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(request);
            }
            case '{': {
                return this.consumeLiteral(request);
            }
        }
        return this.atom(request);
    }

    public String string(ImapRequestLineReader request, Charset charset) throws ProtocolException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(request);
            }
            case '{': {
                return new String(this.consumeLiteralAsBytes(request), charset);
            }
        }
        return this.consumeWord(request);
    }

    public String nstring(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(request);
            }
            case '{': {
                return this.consumeLiteral(request);
            }
        }
        String value = this.consumeWord(request);
        if ("NIL".equals(value)) {
            return null;
        }
        throw new ProtocolException("Invalid nstring value: valid values are '\"...\"', '{12} CRLF *CHAR8', and 'NIL'.");
    }

    public String mailbox(ImapRequestLineReader request) throws ProtocolException {
        String mailbox = this.astring(request);
        if (mailbox.equalsIgnoreCase("INBOX")) {
            return "INBOX";
        }
        return BASE64MailboxDecoder.decode(mailbox);
    }

    public Date dateTime(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        if (next != '\"') {
            throw new ProtocolException("DateTime values must be quoted.");
        }
        String dateString = this.consumeQuoted(request);
        try {
            return new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss Z", Locale.US).parse(dateString);
        }
        catch (ParseException e) {
            throw new ProtocolException("Invalid date format <" + dateString + ">, should comply to dd-MMM-yyyy hh:mm:ss Z");
        }
    }

    protected String consumeWord(ImapRequestLineReader request) throws ProtocolException {
        return this.consumeWord(request, new NoopCharValidator());
    }

    protected String consumeWord(ImapRequestLineReader request, CharacterValidator validator) throws ProtocolException {
        StringBuilder atom = new StringBuilder();
        char next = request.nextWordChar();
        while (!this.isWhitespace(next)) {
            if (!validator.isValid(next)) {
                throw new ProtocolException("Invalid character: '" + next + '\'');
            }
            atom.append(next);
            request.consume();
            next = request.nextChar();
        }
        return atom.toString();
    }

    protected String consumeWordOnly(ImapRequestLineReader request, CharacterValidator validator) throws ProtocolException {
        StringBuilder atom = new StringBuilder();
        char next = request.nextWordChar();
        while (!this.isWhitespace(next)) {
            if (!validator.isValid(next)) {
                return atom.toString();
            }
            atom.append(next);
            request.consume();
            next = request.nextChar();
        }
        return atom.toString();
    }

    private boolean isWhitespace(char next) {
        return next == ' ' || next == '\n' || next == '\r' || next == '\t';
    }

    public long consumeLong(ImapRequestLineReader request) throws ProtocolException {
        StringBuilder atom = new StringBuilder();
        char next = request.nextWordChar();
        while (Character.isDigit(next)) {
            atom.append(next);
            request.consume();
            next = request.nextChar();
        }
        return Long.parseLong(atom.toString());
    }

    protected String consumeLiteral(ImapRequestLineReader request) throws ProtocolException {
        return new String(this.consumeLiteralAsBytes(request));
    }

    protected byte[] consumeLiteralAsBytes(ImapRequestLineReader request) throws ProtocolException {
        this.consumeChar(request, '{');
        StringBuilder digits = new StringBuilder();
        char next = request.nextChar();
        while (next != '}' && next != '+') {
            digits.append(next);
            request.consume();
            next = request.nextChar();
        }
        boolean synchronizedLiteral = true;
        if (next == '+') {
            synchronizedLiteral = false;
            this.consumeChar(request, '+');
        }
        this.consumeChar(request, '}');
        this.consumeCRLF(request);
        if (synchronizedLiteral) {
            request.commandContinuationRequest();
        }
        int size = Integer.parseInt(digits.toString());
        byte[] buffer = new byte[size];
        request.read(buffer);
        return buffer;
    }

    private void consumeCRLF(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextChar();
        if (next != '\n') {
            this.consumeChar(request, '\r');
        }
        this.consumeChar(request, '\n');
    }

    protected void consumeChar(ImapRequestLineReader request, char expected) throws ProtocolException {
        char consumed = request.consume();
        if (consumed != expected) {
            throw new ProtocolException("Expected:'" + expected + "' found:'" + consumed + '\'');
        }
    }

    protected String consumeQuoted(ImapRequestLineReader request) throws ProtocolException {
        this.consumeChar(request, '\"');
        StringBuilder quoted = new StringBuilder();
        char next = request.nextChar();
        while (next != '\"') {
            if (next == '\\') {
                request.consume();
                next = request.nextChar();
                if (!this.isQuotedSpecial(next)) {
                    throw new ProtocolException("Invalid escaped character in quote: '" + next + '\'');
                }
            }
            quoted.append(next);
            request.consume();
            next = request.nextChar();
        }
        this.consumeChar(request, '\"');
        return quoted.toString();
    }

    public Flags flagList(ImapRequestLineReader request) throws ProtocolException {
        Flags flags = new Flags();
        request.nextWordChar();
        this.consumeChar(request, '(');
        NoopCharValidator validator = new NoopCharValidator();
        String nextWord = this.consumeWord(request, validator);
        while (!nextWord.endsWith(")")) {
            this.setFlag(nextWord, flags);
            nextWord = this.consumeWord(request, validator);
        }
        if (nextWord.length() > 1) {
            this.setFlag(nextWord.substring(0, nextWord.length() - 1), flags);
        }
        return flags;
    }

    public void setFlag(String flagString, Flags flags) {
        if (flagString.equalsIgnoreCase("\\ANSWERED")) {
            flags.add(Flags.Flag.ANSWERED);
        } else if (flagString.equalsIgnoreCase("\\DELETED")) {
            flags.add(Flags.Flag.DELETED);
        } else if (flagString.equalsIgnoreCase("\\DRAFT")) {
            flags.add(Flags.Flag.DRAFT);
        } else if (flagString.equalsIgnoreCase("\\FLAGGED")) {
            flags.add(Flags.Flag.FLAGGED);
        } else if (flagString.equalsIgnoreCase("\\SEEN")) {
            flags.add(Flags.Flag.SEEN);
        } else if (flagString.equalsIgnoreCase("\\RECENT")) {
            flags.add(Flags.Flag.RECENT);
        } else {
            flags.add(flagString);
        }
    }

    public long number(ImapRequestLineReader request) throws ProtocolException {
        String digits = this.consumeWord(request, new DigitCharValidator());
        try {
            return Long.parseLong(digits);
        }
        catch (NumberFormatException ex) {
            throw new ProtocolException("Can not parse '" + digits + "' as number", ex);
        }
    }

    public long nzNumber(ImapRequestLineReader request) throws ProtocolException {
        long number = this.number(request);
        if (number == 0L) {
            throw new ProtocolException("Zero value not permitted.");
        }
        return number;
    }

    private boolean isCHAR(char chr) {
        return chr >= '\u0001' && chr <= '\u007f';
    }

    protected boolean isListWildcard(char chr) {
        return chr == '*' || chr == '%';
    }

    private boolean isQuotedSpecial(char chr) {
        return chr == '\"' || chr == '\\';
    }

    public static boolean isCrOrLf(char chr) {
        return '\r' == chr || '\n' == chr;
    }

    public void endLine(ImapRequestLineReader request) throws ProtocolException {
        request.eol();
    }

    public IdRange[] parseIdRange(ImapRequestLineReader request) throws ProtocolException {
        String range;
        MessageSetCharValidator validator = new MessageSetCharValidator();
        String nextWord = this.consumeWord(request, validator);
        int commaPos = nextWord.indexOf(44);
        if (commaPos == -1) {
            return new IdRange[]{IdRange.parseRange(nextWord)};
        }
        ArrayList<IdRange> rangeList = new ArrayList<IdRange>();
        int pos = 0;
        while (commaPos != -1) {
            range = nextWord.substring(pos, commaPos);
            IdRange set = IdRange.parseRange(range);
            rangeList.add(set);
            pos = commaPos + 1;
            commaPos = nextWord.indexOf(44, pos);
        }
        range = nextWord.substring(pos);
        rangeList.add(IdRange.parseRange(range));
        return rangeList.toArray(new IdRange[0]);
    }

    protected boolean isAtomSpecial(char next) {
        return next == '(' || next == ')' || next == '{' || next == ' ' || next == '%' || next == '*' || (float)next <= 1.0f || (float)next == 7.0f || next == '\"' || next == ']';
    }

    private static class MessageSetCharValidator
    implements CharacterValidator {
        private MessageSetCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            return Character.isDigit(chr) || chr == ':' || chr == '*' || chr == ',';
        }
    }

    private class TagCharValidator
    extends AtomCharValidator {
        private TagCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            return chr != '+' && super.isValid(chr);
        }
    }

    protected static class DigitCharValidator
    implements CharacterValidator {
        protected DigitCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            return chr >= '0' && chr <= '9' || chr == '*';
        }
    }

    protected class AtomCharValidator
    implements CharacterValidator {
        protected AtomCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            return CommandParser.this.isCHAR(chr) && !this.isAtomSpecial(chr) && !CommandParser.this.isListWildcard(chr) && !CommandParser.this.isQuotedSpecial(chr);
        }

        private boolean isAtomSpecial(char chr) {
            return chr == '(' || chr == ')' || chr == '{' || chr == ' ' || chr == '\u000f';
        }
    }

    protected static class NoopCharValidator
    implements CharacterValidator {
        protected NoopCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            return true;
        }
    }

    protected static interface CharacterValidator {
        public boolean isValid(char var1);
    }
}

