/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.store.StoredMessageCollection;
import com.icegreen.greenmail.util.MaxSizeLinkedHashMap;
import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapBasedStoredMessageCollection
implements StoredMessageCollection {
    private final Map<Long, StoredMessage> mailMessages;

    public MapBasedStoredMessageCollection(int maximumMapSize) {
        this.mailMessages = Collections.synchronizedMap(new MaxSizeLinkedHashMap(maximumMapSize));
    }

    @Override
    public int size() {
        return this.mailMessages.size();
    }

    @Override
    public void add(StoredMessage storedMessage) {
        this.mailMessages.put(storedMessage.getUid(), storedMessage);
    }

    @Override
    public StoredMessage remove(long uid) {
        StoredMessage msg = this.mailMessages.remove(uid);
        if (null == msg) {
            throw new IllegalArgumentException("No message for uid " + uid + " exists");
        }
        return msg;
    }

    @Override
    public void clear() {
        this.mailMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstUnseen() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            int i2 = 1;
            for (StoredMessage message : this.mailMessages.values()) {
                if (!message.isSet(Flags.Flag.SEEN)) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    @Override
    public int getMsn(long uid) throws FolderException {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            if (this.mailMessages.containsKey(uid)) {
                int i2 = 1;
                for (Long messageUid : this.mailMessages.keySet()) {
                    if (messageUid.equals(uid)) {
                        return i2;
                    }
                    ++i2;
                }
            }
            throw new FolderException("No such message.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getMessages(MsgRangeFilter range) {
        ArrayList<StoredMessage> messagesInRange = new ArrayList<StoredMessage>();
        int i2 = 0;
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            for (StoredMessage message : this.mailMessages.values()) {
                if (range.includes(i2)) {
                    messagesInRange.add(message);
                }
                ++i2;
            }
        }
        return messagesInRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getMessages() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            return new ArrayList<StoredMessage>(this.mailMessages.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMessageUids() {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            long[] uids = new long[this.mailMessages.size()];
            int i2 = 0;
            for (Long uid : this.mailMessages.keySet()) {
                uids[i2] = uid;
                ++i2;
            }
            return uids;
        }
    }

    @Override
    public void expunge(List<FolderListener> mailboxListeners) {
        this.expunge(mailboxListeners, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expunge(List<FolderListener> mailboxListeners, IdRange[] idRanges) {
        int i2 = 1;
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            Iterator<Map.Entry<Long, StoredMessage>> messageEntryIt = this.mailMessages.entrySet().iterator();
            while (messageEntryIt.hasNext()) {
                Map.Entry<Long, StoredMessage> messageEntry = messageEntryIt.next();
                if (messageEntry.getValue().isSet(Flags.Flag.DELETED) && (idRanges == null || IdRange.containsUid(idRanges, messageEntry.getValue().getUid()))) {
                    List<FolderListener> list = mailboxListeners;
                    synchronized (list) {
                        messageEntryIt.remove();
                        for (FolderListener expungeListener : mailboxListeners) {
                            expungeListener.expunged(i2);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredMessage get(int messageIndex) {
        Map<Long, StoredMessage> map = this.mailMessages;
        synchronized (map) {
            int i2 = 0;
            for (StoredMessage message : this.mailMessages.values()) {
                if (messageIndex == i2) {
                    return message;
                }
                ++i2;
            }
        }
        throw new IllegalArgumentException(String.format("No message with index %d found", messageIndex));
    }

    @Override
    public Iterator<StoredMessage> iterator() {
        return this.mailMessages.values().iterator();
    }
}

