/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortex;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.encryption.DumpType;
import picocli.CommandLine;

@CommandLine.Command(description={"generate a new set of demo identity stores"}, name="initDemo", aliases={"init"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreInitDemo
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    @Override
    public Integer call() throws Exception {
        if (new File("identityStore.cfg").exists()) {
            LOGGER.log(Level.SEVERE, "File \"identityStore.cfg\" exists already");
            return 103;
        }
        LOGGER.log(Level.INFO, "creating identity store \"identityStore.cfg\"");
        int ret = MessageVortex.mainReturn(new String[]{"store", "create"});
        if (ret != 0) {
            throw new IOException("Error while creating a new store");
        }
        for (int i2 = 1; i2 <= 9; ++i2) {
            File f = new File("is_dummy" + i2 + ".cfg");
            if (f.exists() && f.delete()) {
                LOGGER.log(Level.INFO, "old identity store \"" + f.getName() + "\" deleted");
            }
            LOGGER.log(Level.INFO, "creating identity store \"" + f.getName() + "\"");
            ret = MessageVortex.mainReturn(new String[]{"store", "create", "--filename", f.getName()});
            if (ret != 0) {
                throw new IOException("Error while creating a new store");
            }
            String tid = "Dummy" + i2 + "@localhost";
            LOGGER.log(Level.INFO, "creating new identity " + tid + " in \"" + f.getName() + "\"");
            ret = MessageVortex.mainReturn(new String[]{"store", "generate", "--filename", f.getName(), "--identityName", tid});
            if (ret != 0) {
                throw new IOException("Error while creating identity store");
            }
            IdentityStore ist = new IdentityStore(f);
            LOGGER.log(Level.INFO, "new identity " + tid + " is " + ist.getIdentityList()[0]);
            String newUrl = ist.getIdentity(ist.getIdentityList()[0]).getUrl();
            LOGGER.log(Level.INFO, "extracted new identity " + tid + " from \"" + f.getName() + "\" (" + newUrl + ")");
            LOGGER.log(Level.INFO, "adding new identity for " + tid + " to main store");
            ret = MessageVortex.mainReturn(new String[]{"store", "add", "--identity", newUrl});
            if (ret == 0) continue;
            throw new IOException("Error while creating a new store");
        }
        LOGGER.log(Level.INFO, "Dumping identity store");
        IdentityStore is = new IdentityStore(new File("identityStore.cfg"));
        System.out.println(is.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        LOGGER.log(Level.INFO, "finished");
        return 0;
    }
}

