/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import net.messagevortex.MessageVortexLogger;

public class CustomKeyManager
extends X509ExtendedKeyManager
implements KeyManager,
X509KeyManager {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final KeyStore keyStore;
    private final String alias;
    char[] password;

    public CustomKeyManager(String keyStoreFile, String password, String alias) throws GeneralSecurityException {
        this(keyStoreFile, password.toCharArray(), alias);
    }

    CustomKeyManager(String keyStoreFile, char[] password, String alias) throws GeneralSecurityException {
        this.password = password;
        this.alias = alias;
        this.keyStore = KeyStore.getInstance("JKS");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(keyStoreFile);){
            this.keyStore.load(is, password);
        }
        catch (IOException ioe) {
            throw new GeneralSecurityException("IOException while loading keystore \"" + keyStoreFile + "\" with password " + new String(password), ioe);
        }
        if (this.getPrivateKey(alias) == null) {
            throw new GeneralSecurityException("requested alias not found in keystore");
        }
    }

    @Override
    public final PrivateKey getPrivateKey(String alias) {
        try {
            LOGGER.log(Level.INFO, "key for \"" + alias + "\" requested ", new Object[]{this.keyStore.getKey(alias, this.password)});
            return (PrivateKey)this.keyStore.getKey(alias, this.password);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "unknown key requested \"" + alias + "\"", e);
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(alias);
            LOGGER.log(Level.INFO, "key chain for \"" + alias + "\" requested ", new Object[]{certs});
            if (certs == null || certs.length == 0) {
                return new X509Certificate[0];
            }
            X509Certificate[] x509 = new X509Certificate[certs.length];
            for (int i2 = 0; i2 < certs.length; ++i2) {
                x509[i2] = (X509Certificate)certs[i2];
            }
            return x509;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "unknown key requested \"" + alias + "\"", e);
            return new X509Certificate[0];
        }
    }

    @Override
    public String[] getClientAliases(String param1, Principal[] param2) {
        LOGGER.log(Level.INFO, "client alias list for  \"" + this.alias + "\" requested ");
        return new String[]{this.alias};
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(null, null, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(null, null, null);
    }

    @Override
    public String chooseClientAlias(String[] param1, Principal[] param2, Socket param3) {
        LOGGER.log(Level.INFO, "client alias for  \"" + this.alias + "\" requested ");
        return this.alias;
    }

    @Override
    public String[] getServerAliases(String param1, Principal[] param2) {
        LOGGER.log(Level.INFO, "server alias list for  \"" + this.alias + "\" requested ");
        return new String[]{this.alias};
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        LOGGER.log(Level.INFO, "server alias (1) for \"" + this.alias + "\" requested ");
        return this.alias;
    }

    public String chooseServerAlias(String param1, Principal[] param2) {
        LOGGER.log(Level.INFO, "server alias (2) for \"" + this.alias + "\" requested ");
        return this.alias;
    }
}

