/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapConnection;
import net.messagevortex.transport.imap.ImapConnectionState;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;

public class ImapCommandLogout
extends ImapCommand {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    @Override
    public String[] processCommand(ImapLine line) throws ImapException {
        line.skipWhitespace(-1);
        if (!line.skipLineEnd()) {
            throw new ImapException(line, "error parsing command");
        }
        if (line.getConnection() != null) {
            line.getConnection().setImapState(ImapConnectionState.CONNECTION_NOT_AUTHENTICATED);
        }
        LOGGER.log(Level.INFO, Thread.currentThread().getName() + " is now in state NOT_AUTHENTICATED");
        return new String[]{"* BYE IMAP4rev1 Server logged out\r\n", line.getTag() + " OK\r\n", null};
    }

    @Override
    public String[] getCommandIdentifier() {
        return new String[]{"LOGOUT"};
    }

    @Override
    public String[] getCapabilities(ImapConnection conn) {
        return new String[0];
    }
}

