/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public final class BranchHandle
extends InstructionHandle {
    private BranchInstruction bi;

    static BranchHandle getBranchHandle(BranchInstruction i2) {
        return new BranchHandle(i2);
    }

    private BranchHandle(BranchInstruction i2) {
        super(i2);
        this.bi = i2;
    }

    @Override
    public int getPosition() {
        return this.bi.getPosition();
    }

    public InstructionHandle getTarget() {
        return this.bi.getTarget();
    }

    @Override
    public void setInstruction(Instruction i2) {
        super.setInstruction(i2);
        if (!(i2 instanceof BranchInstruction)) {
            throw new ClassGenException("Assigning " + i2 + " to branch handle which is not a branch instruction");
        }
        this.bi = (BranchInstruction)i2;
    }

    @Override
    void setPosition(int pos) {
        this.bi.setPosition(pos);
        super.setPosition(pos);
    }

    public void setTarget(InstructionHandle ih) {
        this.bi.setTarget(ih);
    }

    @Override
    protected int updatePosition(int offset, int maxOffset) {
        int x = this.bi.updatePosition(offset, maxOffset);
        super.setPosition(this.bi.getPosition());
        return x;
    }

    public void updateTarget(InstructionHandle oldIh, InstructionHandle newIh) {
        this.bi.updateTarget(oldIh, newIh);
    }
}

