/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgBlameConsumer
extends HgConsumer {
    private final List<BlameLine> lines = new ArrayList<BlameLine>();
    private static final String HG_TIMESTAMP_PATTERN = "EEE MMM dd HH:mm:ss yyyy Z";

    @Override
    public void doConsume(ScmFileStatus status, String trimmedLine) {
        String annotation = trimmedLine.indexOf(": ") > -1 ? trimmedLine.substring(0, trimmedLine.indexOf(": ")).trim() : trimmedLine.substring(0, trimmedLine.lastIndexOf(":")).trim();
        String author = annotation.substring(0, annotation.indexOf(32));
        annotation = annotation.substring(annotation.indexOf(32) + 1).trim();
        String revision = annotation.substring(0, annotation.indexOf(32));
        String dateStr = annotation = annotation.substring(annotation.indexOf(32) + 1).trim();
        Date dateTime = this.parseDate(dateStr, null, HG_TIMESTAMP_PATTERN, Locale.ENGLISH);
        this.lines.add(new BlameLine(dateTime, revision, author));
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

