/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.parallel;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.MAINTAINED, since="5.13.3")
public interface ResourceLocksProvider {
    default public Set<Lock> provideForClass(Class<?> testClass) {
        return Collections.emptySet();
    }

    default public Set<Lock> provideForNestedClass(List<Class<?>> enclosingInstanceTypes, Class<?> testClass) {
        return Collections.emptySet();
    }

    default public Set<Lock> provideForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
        return Collections.emptySet();
    }

    public static final class Lock {
        private final String key;
        private final ResourceAccessMode accessMode;

        public Lock(String key) {
            this(key, ResourceAccessMode.READ_WRITE);
        }

        public Lock(String key, ResourceAccessMode accessMode) {
            this.key = Preconditions.notBlank(key, "key must not be null or blank");
            this.accessMode = Preconditions.notNull(accessMode, "accessMode must not be null");
        }

        public String getKey() {
            return this.key;
        }

        public ResourceAccessMode getAccessMode() {
            return this.accessMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Lock that = (Lock)o;
            return this.key.equals(that.key) && this.accessMode == that.accessMode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.accessMode});
        }

        public String toString() {
            return new ToStringBuilder(this).append("key", this.key).append("accessMode", (Object)this.accessMode).toString();
        }
    }
}

