/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.PayloadChunk;
import net.messagevortex.asn1.RemoveRedundancyOperation;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.router.operation.AbstractOperation;
import net.messagevortex.router.operation.GaloisFieldMathMode;
import net.messagevortex.router.operation.MathMode;
import net.messagevortex.router.operation.Matrix;
import net.messagevortex.router.operation.RedundancyMatrix;

public class RemoveRedundancy
extends AbstractOperation
implements Serializable {
    public static final long serialVersionUID = 100000000020L;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    RemoveRedundancyOperation operation;

    public RemoveRedundancy(RemoveRedundancyOperation op) {
        this.operation = op;
    }

    @Override
    public boolean canRun() {
        if (this.payload == null) {
            return false;
        }
        int j = 0;
        for (int i : this.getInputId()) {
            if (this.payload.getPayload(i) == null) continue;
            ++j;
        }
        return j >= this.operation.getDataStripes();
    }

    @Override
    public int[] execute(int[] id) {
        if (!this.canRun()) {
            return new int[0];
        }
        LOGGER.log(Level.INFO, "executing add redundancy operation");
        LOGGER.log(Level.INFO, "  analysing stripes");
        ArrayList<Integer> l = new ArrayList<Integer>();
        int stripeSize = -1;
        int stripesFound = 0;
        for (int i : this.getInputId()) {
            PayloadChunk p = this.payload.getPayload(i);
            if (p == null || stripesFound >= this.operation.getDataStripes()) {
                l.add(i);
                if (p == null) continue;
                ++stripesFound;
                continue;
            }
            ++stripesFound;
            if (stripeSize == -1) {
                stripeSize = p.getPayload().length;
                continue;
            }
            if (stripeSize == p.getPayload().length) continue;
            return new int[0];
        }
        int[] missingIds = new int[l.size()];
        for (int i = 0; i < missingIds.length; ++i) {
            missingIds[i] = (Integer)l.get(i);
        }
        LOGGER.log(Level.INFO, "  got " + stripesFound + "/" + (this.operation.getDataStripes() + this.operation.getRedundancy()) + " stripes. Stripe size is " + stripeSize);
        byte[] in2 = new byte[stripeSize * (this.operation.getDataStripes() + this.operation.getRedundancy() - missingIds.length)];
        try {
            int j = 0;
            for (int i : this.getInputId()) {
                if (l.contains(i)) continue;
                for (byte b : this.operation.getKeys()[i - this.getInputId()[0]].decrypt(this.payload.getPayload(i).getPayload())) {
                    in2[j++] = b;
                }
            }
        }
        catch (IOException ioe) {
            return new int[0];
        }
        GaloisFieldMathMode mm = GaloisFieldMathMode.getGaloisFieldMathMode(this.operation.getGfSize());
        Matrix data = new Matrix(in2.length / (this.operation.getDataStripes() + this.operation.getRedundancy() - missingIds.length), this.operation.getDataStripes() + this.operation.getRedundancy() - missingIds.length, (MathMode)mm, in2);
        LOGGER.log(Level.INFO, "  created " + data.getX() + "x" + data.getY() + " data matrixContent");
        RedundancyMatrix r = new RedundancyMatrix(this.operation.getDataStripes(), this.operation.getDataStripes() + this.operation.getRedundancy(), mm);
        LOGGER.log(Level.INFO, "  created " + r.getX() + "x" + r.getY() + " redundancy matrixContent");
        Matrix recovery = r.getRecoveryMatrix(missingIds);
        LOGGER.log(Level.INFO, "  created " + recovery.getX() + "x" + recovery.getY() + " recovery matrixContent");
        LOGGER.log(Level.INFO, "  reconstructing data");
        Matrix out = recovery.mul(data);
        int paddingSize = 4;
        LOGGER.log(Level.INFO, "  removing padding");
        byte[] out1 = out.getAsByteArray();
        byte[] len = Arrays.copyOf(out1, paddingSize);
        int outputLength = (int)VortexMessage.getBytesAsLong(len);
        LOGGER.log(Level.INFO, "    message size is " + outputLength + " (padded: " + out1.length + ")");
        byte[] out2 = new byte[outputLength];
        System.arraycopy(out1, paddingSize, out2, 0, outputLength);
        LOGGER.log(Level.INFO, "  setting output");
        this.payload.setCalculatedPayload(this.getOutputId()[0], new PayloadChunk(this.getOutputId()[0], out2, this.getUsagePeriod()));
        LOGGER.log(Level.INFO, "  done");
        return this.getOutputId();
    }

    @Override
    public int[] getOutputId() {
        int[] ret = new int[this.operation.getDataStripes() + this.operation.getRedundancy()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.operation.getOutputId() + i;
        }
        return ret;
    }

    @Override
    public int[] getInputId() {
        int[] ret = new int[this.operation.getDataStripes() + this.operation.getRedundancy()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.operation.getInputId() + i;
        }
        return ret;
    }

    public String toString() {
        return this.getInputId()[0] + "->(" + this.getInputId().length + ")removeRedundancy(" + this.getOutputId().length + ")->" + this.getOutputId()[0];
    }
}

