/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.inheritance;

import java.net.URI;
import java.net.URISyntaxException;
import org.codehaus.plexus.util.PathTool;

public class URIPathDescriptor {
    private final URI baseURI;
    private final URI link;

    public URIPathDescriptor(String baseURI, String link) {
        String llink = URIPathDescriptor.sanitizeLink(link);
        String bbase = URIPathDescriptor.sanitizeBase(baseURI);
        this.baseURI = URI.create(bbase).normalize();
        this.link = URI.create(llink).normalize();
        if (!this.baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Base URI is not absolute: " + baseURI);
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public URI getLink() {
        return this.link;
    }

    public URI resolveLink() {
        return this.baseURI.resolve(this.link);
    }

    public URI relativizeLink() {
        return URIPathDescriptor.relativizeLink(this.baseURI.toString(), this.link);
    }

    private static URI relativizeLink(String base, URI link) {
        if (!link.isAbsolute()) {
            return link;
        }
        URI newBaseURI = URI.create(base);
        if (!URIPathDescriptor.sameSite(link, newBaseURI)) {
            return link;
        }
        String relativePath = PathTool.getRelativeWebPath((String)newBaseURI.toString(), (String)link.toString());
        return URI.create(URIPathDescriptor.correctRelativePath(relativePath));
    }

    public URI rebaseLink(String newBase) {
        URI newBaseURI;
        if (this.link.isAbsolute()) {
            return this.link;
        }
        if (newBase == null) {
            return this.resolveLink();
        }
        try {
            newBaseURI = new URI(newBase);
        }
        catch (URISyntaxException ex) {
            return this.resolveLink();
        }
        if (!this.sameSite(newBaseURI)) {
            return this.resolveLink();
        }
        String relativeBasePath = PathTool.getRelativeWebPath((String)newBaseURI.getPath(), (String)this.baseURI.getPath());
        return URI.create(URIPathDescriptor.correctRelativePath(relativeBasePath)).resolve(this.link);
    }

    private static String correctRelativePath(String relativePath) {
        if ("".equals(relativePath) || "/".equals(relativePath)) {
            return "./";
        }
        return relativePath;
    }

    public boolean sameSite(URI uri) {
        return uri != null && URIPathDescriptor.sameSite(this.baseURI, uri);
    }

    private static boolean sameSite(URI baseURI, URI newBaseURI) {
        boolean sameScheme;
        boolean bl = sameScheme = newBaseURI.getScheme() == null ? false : baseURI.getScheme().equalsIgnoreCase(newBaseURI.getScheme());
        boolean sameHost = baseURI.getHost() == null ? newBaseURI.getHost() == null : baseURI.getHost().equalsIgnoreCase(newBaseURI.getHost());
        boolean samePort = baseURI.getPort() == newBaseURI.getPort();
        return sameScheme && samePort && sameHost;
    }

    public String toString() {
        return this.resolveLink().toString();
    }

    private static String sanitizeBase(String base) {
        String sane = base.replace('\\', '/');
        if (!sane.endsWith("/")) {
            sane = sane + "/";
        }
        return sane;
    }

    private static String sanitizeLink(String link) {
        String sane = link.replace('\\', '/');
        if (sane.startsWith("/")) {
            sane = sane.substring(1);
        }
        return sane;
    }
}

